<?php
/**
 * Plugin Name:       In-Page Navigation Menu
 * Description:       A beautiful, interactive in-page navigation menu that creates a table of contents from headings on the page.
 * Version:           0.1.0
 * Requires at least: 6.1
 * Requires PHP:      7.0
 * Author:            WordPress Telex
 * License:           GPLv2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       in-page-nav-menu
 *
 * @package TelexInPageNavMenu
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Registers the block using the metadata loaded from the `block.json` file.
 * Behind the scenes, it registers also all assets so they can be enqueued
 * through the block editor in the corresponding context.
 *
 * @see https://developer.wordpress.org/reference/functions/register_block_type/
 */
function telex_in_page_nav_menu_block_init() {
	register_block_type( __DIR__ . '/build/' );
}
add_action( 'init', 'telex_in_page_nav_menu_block_init' );
