<?php
/**
 * @see https://github.com/WordPress/gutenberg/blob/trunk/docs/reference-guides/block-api/block-metadata.md#render
 */

$line_color = isset( $attributes['lineColor'] ) ? esc_attr( $attributes['lineColor'] ) : '#000000';
$line_color_hover = isset( $attributes['lineColorHover'] ) ? esc_attr( $attributes['lineColorHover'] ) : '#0073aa';
$text_color = isset( $attributes['textColor'] ) ? esc_attr( $attributes['textColor'] ) : '#000000';
$line_thickness = isset( $attributes['lineThickness'] ) ? absint( $attributes['lineThickness'] ) : 2;
$line_thickness_hover = isset( $attributes['lineThicknessHover'] ) ? absint( $attributes['lineThicknessHover'] ) : 4;
$line_length = isset( $attributes['lineLength'] ) ? absint( $attributes['lineLength'] ) : 40;
$line_length_hover = isset( $attributes['lineLengthHover'] ) ? absint( $attributes['lineLengthHover'] ) : 60;

// Generate unique ID for this block instance
$block_id = 'nav-menu-' . wp_unique_id();

// Render a placeholder that will be populated by JavaScript
// This avoids infinite recursion and allows the JS to scan the actual rendered page
?>

<div <?php echo get_block_wrapper_attributes(); ?>>
	<style>
		#<?php echo $block_id; ?> .in-page-nav-menu-link {
			outline-offset: 4px;
		}
		
		#<?php echo $block_id; ?> .in-page-nav-menu-link:focus {
			outline: 2px solid <?php echo $line_color_hover; ?>;
			outline-offset: 4px;
		}
		
		#<?php echo $block_id; ?> .in-page-nav-menu-line {
			background-color: <?php echo $line_color; ?>;
			height: <?php echo $line_thickness; ?>px;
			width: <?php echo $line_length; ?>px;
		}
		
		#<?php echo $block_id; ?> .in-page-nav-menu-link:hover .in-page-nav-menu-line,
		#<?php echo $block_id; ?> .in-page-nav-menu-link:focus .in-page-nav-menu-line {
			background-color: <?php echo $line_color_hover; ?>;
			height: <?php echo $line_thickness_hover; ?>px;
			width: <?php echo $line_length_hover; ?>px;
		}
		
		#<?php echo $block_id; ?> .in-page-nav-menu-text {
			color: <?php echo $text_color; ?>;
		}
		
		#<?php echo $block_id; ?> .in-page-nav-menu-link.active .in-page-nav-menu-line {
			background-color: <?php echo $line_color_hover; ?>;
		}
	</style>
	
	<nav id="<?php echo $block_id; ?>" class="in-page-nav-menu-container" aria-label="<?php echo esc_attr__( 'Page navigation', 'in-page-nav-menu' ); ?>" aria-expanded="false">
		<h2 class="sr-only"><?php echo esc_html__( 'Table of Contents', 'in-page-nav-menu' ); ?></h2>
		
		<button class="in-page-nav-menu-toggle" aria-label="<?php echo esc_attr__( 'Toggle navigation menu', 'in-page-nav-menu' ); ?>">
			<span class="in-page-nav-menu-toggle-text"><?php echo esc_html__( 'Jump to section', 'in-page-nav-menu' ); ?></span>
			<span class="in-page-nav-menu-toggle-icon" aria-hidden="true">▼</span>
		</button>
		
		<ol class="in-page-nav-menu-list" aria-label="<?php echo esc_attr__( 'Table of contents', 'in-page-nav-menu' ); ?>">
			<!-- Navigation items will be populated by JavaScript -->
		</ol>
	</nav>
</div>